<?php

namespace App\Http\Controllers;

use App\Models\DataJemaat;
use App\Models\DataKl;
use App\Models\DataSektor;
use App\Models\DataWilayah;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class DashboardController extends Controller
{
    public function index(){
        $dataKK = DataKl::where("status","1")->get()->count();
        $dataPasangan = DataJemaat::where("peran","2")->get()->count();
        $dataAnak = DataJemaat::where("peran","3")->get()->count();
        $dataSaudara = DataJemaat::where("peran","4")->get()->count();
        $dataOrangTua = DataJemaat::where("peran","5")->get()->count();
        $dataMenantu = DataJemaat::where("peran","6")->get()->count();
        $dataCucu = DataJemaat::where("peran","7")->get()->count();
        $dataLainnya = DataJemaat::where("peran","8")->get()->count();
        $dataJemaat = DataJemaat::where("status","1")->get()->count();
        $dataDisabilitas = DataJemaat::where("status","1")->where("DISABILITAS","1")->get()->count();
        $dataBaptisDewasa = DataJemaat::where("status","1")->where("PINDAHAN_AGAMA_LAIN","1")->whereYear("TGL_BAPTIS",Carbon::now()->subYear()->year)->get()->count();
        $dataPindahanKeKristen = DataJemaat::where("status","1")->where("PINDAHAN_AGAMA_LAIN","1")->whereYear("TGL_AGAMA_LAIN",Carbon::now()->subYear()->year)->get()->count();
        $dataPindahanDariKristen = DataJemaat::where("status","4")->where("PINDAHAN_DARI_KRISTEN","1")->whereYear("TGL_DARI_KRISTEN",Carbon::now()->subYear()->year)->get()->count();
        $dataTitipan = DataJemaat::where("status","2")->get()->count();
        $dataJemaatL = DataJemaat::where("status","1")->where("jk","L")->get()->count();
        $dataJemaatP = DataJemaat::where("status","1")->where("jk","P")->get()->count();
        $dataKeluarga = DataKl::where("status","1")->get()->count();
        $dataSektor = DataSektor::get()->count();
        $dataWilayah = DataWilayah::get()->count();
        $dataUltah = DB::select("SELECT NAMA, CONCAT(DAY(TGL_LAHIR),' ',MONTHNAME(STR_TO_DATE(MONTH(TGL_LAHIR),'%m'))) as lahir, CONCAT(MONTH(TGL_LAHIR),'-',DAY(TGL_LAHIR)) as ordering FROM data_jemaat WHERE (STATUS != 5 OR STATUS != 6) AND (STR_TO_DATE( CONCAT(YEAR(CURDATE()), '-', MONTH(TGL_LAHIR), '-', DAY(TGL_LAHIR) ), '%Y-%m-%d' ) between curdate() and curdate() + INTERVAL 1 WEEK) ORDER BY ordering asc");
        $dataJumlahSektor = DB::select("SELECT data_sektor.*, (SELECT COUNT(*) FROM data_jemaat WHERE data_jemaat.SEKTOR = data_sektor.id AND data_jemaat.STATUS = 1) AS TOTAL FROM data_sektor");
        $dataJumlahSektorKosong = DB::select("SELECT COUNT(*) AS sektor_kosong FROM data_jemaat WHERE (data_jemaat.SEKTOR IS NULL OR data_jemaat.SEKTOR = 0) AND data_jemaat.STATUS = 1")[0]->sektor_kosong;
        $dataJumlahWilayah = DB::select("SELECT data_wilayah.*, (SELECT COUNT(*) FROM data_jemaat WHERE data_jemaat.WILAYAH = data_wilayah.id AND data_jemaat.STATUS = 1) AS TOTAL FROM data_wilayah");
        $dataJumlahWilayahKosong = DB::select("SELECT COUNT(*) AS wilayah_kosong FROM data_jemaat WHERE (data_jemaat.WILAYAH IS NULL OR data_jemaat.WILAYAH = 0) AND data_jemaat.STATUS = 1")[0]->wilayah_kosong;
        $dataJumlahKeluargaSektor = DB::select("SELECT data_sektor.*, (SELECT COUNT(*) FROM data_kl WHERE data_kl.SEKTOR = data_sektor.id AND data_kl.STATUS = 1) AS TOTAL FROM data_sektor");
        $dataJumlahKeluargaSektorKosong = DB::select("SELECT COUNT(*) AS sektor_kosong FROM data_kl WHERE (data_kl.SEKTOR IS NULL OR data_kl.SEKTOR = 0) AND data_kl.STATUS = 1")[0]->sektor_kosong;
        $dataJumlahKeluargaWilayah = DB::select("SELECT data_wilayah.*, (SELECT COUNT(*) FROM data_kl WHERE data_kl.WILAYAH = data_wilayah.id AND data_kl.STATUS = 1) AS TOTAL FROM data_wilayah");
        $dataJumlahKeluargaWilayahKosong = DB::select("SELECT COUNT(*) AS wilayah_kosong FROM data_kl WHERE (data_kl.WILAYAH IS NULL OR data_kl.WILAYAH = 0) AND data_kl.STATUS = 1")[0]->wilayah_kosong;
        $dataLahirTahunIni = DataJemaat::where("status","1")->whereYear("TGL_LAHIR",Carbon::now()->subYear()->year)->get()->count();
        $dataMeninggalTahunIni = DataJemaat::where("status","5")->whereYear("TANGGAL_MENINGGAL",Carbon::now()->subYear()->year)->get()->count();
        $dataDuda = DataJemaat::where("status","1")->where("jk","L")->where("STATUS_PERKAWINAN","Duda/Janda")->get()->count();
        $dataJanda = DataJemaat::where("status","1")->where("jk","P")->where("STATUS_PERKAWINAN","Duda/Janda")->get()->count();
        $dataSendiri = DataJemaat::where("status","1")->where("peran", "1")->where("STATUS_PERKAWINAN","Belum Kawin")->get()->count();
        $dataKeluargaMasuk = DataKl::where("status","1")->where("TANGGAL_MASUK","!=",NULL)->whereYear("TANGGAL_MASUK",Carbon::now()->subYear()->year)->get()->count();
        $dataKeluargaKeluar = DataKl::where("TANGGAL_KELUAR","!=", NULL)->whereYear("TANGGAL_KELUAR",Carbon::now()->subYear()->year)->get()->count();
        $list = DataJemaat::where("status","1")->get()->toArray();
        $list2 = DataKl::where("status","1")->get()->toArray();
        $totala = 0;
        $totalb = 0;
        foreach ($list as $a) {
            foreach ($a as $b){
                if($b == "-" || $b == "0" || $b == "" || $b == null){
                    $totalb += 1;
                } else {
                    $totala += 1;
                }
            }
        }
        foreach ($list2 as $a) {
            foreach ($a as $b){
                if($b == "-" || $b == "0" || $b == "" || $b == null){
                    $totalb += 1;
                } else {
                    $totala += 1;
                }
            }
        }
        $total = $totala+$totalb;
        $terisi = round(($totala/$total)*100, 1, \PHP_ROUND_HALF_UP);
        $kosong = round(($totalb/$total)*100, 1, \PHP_ROUND_HALF_UP);
        $totalSidi = DataJemaat::where("status","1")->where("TGL_SIDI","!=",null)->orWhere("TGL_SIDI","!=","0000-00-00")->get()->count();

        $ranges = [ // the start of each age-range.
            '0-5' => 0,
            '6-11' => 6,
            '12-14' => 12,
            '15-17' => 15,
            '18-23' => 18,
            '24-29' => 24,
            '30-59' => 30,
            '60-69' => 60,
            '70+' => 70
        ];

        $umur = DataJemaat::where("status","1")->get()
            ->map(function ($user) use ($ranges) {
                $age = Carbon::parse($user->TGL_LAHIR)->age;
                foreach($ranges as $key => $breakpoint)
                {
                    if ($breakpoint >= $age)
                    {
                        $user->range = $key;
                        break;
                    }
                }

                return $user;
            })
            ->mapToGroups(function ($user, $key) {
                return [$user->range => $user];
            })
            ->map(function ($group) {
                return count($group);
            })
            ->sortKeys();

        $ranges2 = [ // the start of each age-range.
            '0-16' => 0,
            '17-35' => 18,
            '36+' => 36
        ];

        $pemuda = DataJemaat::where("status","1")->get()
            ->map(function ($user) use ($ranges2) {
                $age = Carbon::parse($user->TGL_LAHIR)->age;
                foreach($ranges2 as $key => $breakpoint)
                {
                    if ($breakpoint >= $age)
                    {
                        $user->range = $key;
                        break;
                    }
                }

                return $user;
            })
            ->mapToGroups(function ($user, $key) {
                return [$user->range => $user];
            })
            ->map(function ($group) {
                return count($group);
            })
            ->sortKeys();

        $dataLKawin = DataJemaat::where("status","1")->where("JK","L")
        ->where("STATUS_PERKAWINAN","Kawin")
        ->get();

        $dataPKawin = DataJemaat::where("status","1")->where("JK","P")
        ->where("STATUS_PERKAWINAN","Kawin")
        ->get();

        // get from DataLKawin where carbon age is under 60
        $dataKaumBapak = $dataLKawin->map(function ($user) {
            $age = Carbon::parse($user->TGL_LAHIR)->age;
            if ($age < 60) {
                return $user;
            }
        })->count();

        $dataKaumIbu = $dataPKawin->map(function ($user) {
            $age = Carbon::parse($user->TGL_LAHIR)->age;
            if ($age < 60) {
                return $user;
            }
        })->count();

        $retval = [
            "dataKK" => $dataKK,
            "dataPasangan" => $dataPasangan,
            "dataAnak" => $dataAnak,
            "dataSaudara" => $dataSaudara,
            "dataOrangTua" => $dataOrangTua,
            "dataMenantu" => $dataMenantu,
            "dataCucu" => $dataCucu,
            "dataLainnya" => $dataLainnya,
            "dataJemaat" => $dataJemaat,
            "dataDisabilitas" => $dataDisabilitas,
            "dataTitipan" => $dataTitipan,
            "dataJemaatL" => $dataJemaatL,
            "dataJemaatP" => $dataJemaatP,
            "dataKeluarga" => $dataKeluarga,
            "dataSektor" => $dataSektor,
            "dataWilayah" => $dataWilayah,
            "dataUltah" => $dataUltah,
            "dataJumlahSektor" => $dataJumlahSektor,
            "dataJumlahWilayah" => $dataJumlahWilayah,
            "dataJumlahKeluargaSektor" => $dataJumlahKeluargaSektor,
            "dataJumlahKeluargaWilayah" => $dataJumlahKeluargaWilayah,
            "dataJumlahSektorKosong" => $dataJumlahSektorKosong,
            "dataJumlahWilayahKosong" => $dataJumlahWilayahKosong,
            "dataJumlahKeluargaSektorKosong" => $dataJumlahKeluargaSektorKosong,
            "dataJumlahKeluargaWilayahKosong" => $dataJumlahKeluargaWilayahKosong,
            "dataUmur" => $umur,
            "dataLahirTahunIni" => $dataLahirTahunIni,
            "dataMeninggalTahunIni" => $dataMeninggalTahunIni,
            "dataDuda" => $dataDuda,
            "dataJanda" => $dataJanda,
            "dataSendiri" => $dataSendiri,
            "dataPemuda" => $pemuda,
            "dataSidi" => $totalSidi,
            "dataBaptisDewasa" => $dataBaptisDewasa,
            "dataPindahanKeKristen" => $dataPindahanKeKristen,
            "dataPindahanDariKristen" => $dataPindahanDariKristen,
            "dataKeluargaMasuk" => $dataKeluargaMasuk,
            "dataKeluargaKeluar" => $dataKeluargaKeluar,
            "dataKaumBapak" => $dataKaumBapak,
            "dataKaumIbu" => $dataKaumIbu,
            "terisi" => $terisi,
            "kosong" => $kosong,
        ];
        return response()->json(array('data' => $retval));
    }
}
