<?php

namespace App\Http\Controllers;

use App\Models\DataJabatan;
use App\Models\DataJemaat;
use App\Models\DataPekerjaan;
use App\Models\DataPendidikan;
use App\Models\DataPerkawinan;
use App\Models\DataProfesi;
use App\Models\DataSektor;
use App\Models\DataStatus;
use App\Models\DataStatuskl;
use App\Models\DataGoldar;
use App\Models\DataWilayah;
// use App\Services\PineconeService;
use Carbon\Carbon;
use Exception;
use Gemini\Laravel\Facades\Gemini;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use stdClass;
use Symfony\Component\HttpFoundation\StreamedResponse;

class JemaatController extends Controller
{
    // private $pineconeService;
    
    // public function __construct(PineconeService $pineconeService)
    // {
    //     $this->pineconeService = $pineconeService;
    // }

    public function index(Request $request){
        $query = DataJemaat::query();
        
        if($request->search){
            $query->where("NAMA","LIKE","%".$request->search."%");
        }
        
        if($request->wilayah){
            $query->where("WILAYAH", $request->wilayah);
        }
        
        if($request->sektor){
            $query->where("SEKTOR", $request->sektor);
        }

        $query->orderBy("updated_at","DESC");

        Log::info($query->toSql());
        
        $dataJemaat = $query->paginate();
        return response()->json(array('data' => $dataJemaat));
    }

    public function getAnggota(Request $request){
        $dataJemaat = DataJemaat::where("ID_KELUARGA","=","")->orWhereNull("ID_KELUARGA")->get();
        return response()->json(array('data' => $dataJemaat));
    }

    public function find(string $id, Request $request){
        $dataJemaat = DataJemaat::find($id);
        if($dataJemaat->JK == "L"){
            $jk = new stdClass;
            $jk->id = "L";
            $jk->nama = "Laki-Laki";
            $dataJemaat->JK = $jk;
        } else {
            $jk = new stdClass;
            $jk->id = "P";
            $jk->nama = "Perempuan";
            $dataJemaat->JK = $jk;

        }

        if($dataJemaat->DISABILITAS == "0"){
            $DISABILITAS = new stdClass;
            $DISABILITAS->id = "0";
            $DISABILITAS->nama = "Tidak";
            $dataJemaat->DISABILITAS = $DISABILITAS;
        } else {
            $DISABILITAS = new stdClass;
            $DISABILITAS->id = "1";
            $DISABILITAS->nama = "Ya";
            $dataJemaat->DISABILITAS = $DISABILITAS;

        }

        $dataJemaat->GOL_DARAH = DataGoldar::where('nama', $dataJemaat->GOL_DARAH)->first();
        $dataJemaat->TGL_LAHIR = Carbon::parse($dataJemaat->TGL_LAHIR)->format('Y-m-d');
        $dataJemaat->STATUS_PERKAWINAN = DataPerkawinan::where('nama', $dataJemaat->STATUS_PERKAWINAN)->first();
        $dataJemaat->STATUS = DataStatus::find($dataJemaat->STATUS);
        $dataJemaat->WILAYAH = DataWilayah::find($dataJemaat->WILAYAH);
        $dataJemaat->SEKTOR = DataSektor::find($dataJemaat->SEKTOR);
        $dataJemaat->PENDIDIKAN = DataPendidikan::where('nama', $dataJemaat->PENDIDIKAN)->first();
        $dataJemaat->PEKERJAAN = DataPekerjaan::where('nama', $dataJemaat->PEKERJAAN)->first();
        $dataJemaat->JABATAN = DataJabatan::where('nama', $dataJemaat->JABATAN)->first();
        $dataJemaat->PROFESI = DataProfesi::where('nama', $dataJemaat->PROFESI)->first();
        return response()->json(array('data' => $dataJemaat));
    }

    public function add(Request $request){
        try{
            $data = $request->all();
            DataJemaat::create($data);
            return response()->json(array('success' => true, 'message' => 'Data Tersimpan'));
        } catch(Exception $ex){
            return response()->json(array('success' => false, 'message' => 'Gagal, error: ' . $ex->getMessage()), 400);
        }
    }
    public function update(Request $request){
        try{
            $update = DataJemaat::find($request->id);
            $data = $request->all();
            $update->update($data);
            return response()->json(array('success' => true, 'message' => 'Data Tersimpan'));
        } catch(Exception $ex){
            return response()->json(array('success' => false, 'message' => 'Gagal, error: ' . $ex->getMessage()), 400);
        }
    }
    public function delete(Request $request){
        try{
            $update = DataJemaat::find($request->id);
            $update->delete();
            return response()->json(array('success' => true, 'message' => 'Data Terhapus'));
        } catch(Exception $ex){ 
            return response()->json(array('success' => false, 'message' => 'Gagal, error: ' . $ex->getMessage()), 400);
        }
    }

    public function handleChat(Request $request)
    {
        $userInput = $request->input('message');
        return $this->handleUserQuery($userInput);
    }

    function handleUserQuery(string $userInput)
    {
        $dateNow = Carbon::now()->format("Y-m-d");
        $schemaDescription = <<<EOT
    Tanggal hari ini adalah: $dateNow
     
    Tabel `data_jemaat` menyimpan informasi jemaat secara individual. Kolom penting:
    - NAMA (varchar)
    - ID_KELUARGA (int)
    - PERAN (int, id untuk statuskl)
    - JK (varchar: 'L' atau 'P')
    - WILAYAH (int), SEKTOR (int)
    - TGL_LAHIR (date), umur (int)
    - PERAN, PEKERJAAN, STATUS_PERKAWINAN, TGL_BAPTIS, TGL_SIDI, ALAMAT

    Tabel `data_kl` menyimpan informasi keluarga. Kolom penting:
    - ID_KELUARGA (int, digunakan untuk mencari anggota keluarga di jemaat)
    - WILAYAH, SEKTOR
    - STATUS_KELUARGA, ALAMAT, TANGGAL_MASUK, TANGGAL_KELUAR

    Tabel 'data_statuskl' menyimpan informasi PERAN dengan data sebagai berikut:
    "id","nama"
    "1","Kepala Keluarga"
    "2","Istri / Pasangan"
    "3","Anak"
    "4","Saudara"
    "5","Orang Tua"
    "6","Menantu"
    "7","Cucu"
    "8","Lainnya"

    Tabel data_sektor memuat data sektor sebagai berikut:
    "id","nama"
    "1","Dangin Puri"
    "2","Sumerta I"
    "3","Sumerta II"
    "4","Tonja"
    "5","Penatih"
    "6","Sanur"
    "7","Panjer"
    "8","Renon"
    "9","Sesetan I & II"
    "10","Sidakarya"
    "11","Pedungan Kuta"
    "12","Dauh Puri I"
    "13","Pemecutan"
    "14","Peguyangan"
    "15","Ubung Kaja"
    "16","Padang Sambian Kelod I"
    "17","Padang Sambian Kaja I"
    "18","Kesiman"
    "19","Dauh Puri II"
    "20","Tegal Harum"
    "21","Tegal Kertha"
    "22","Padang Sambian Kelod II"
    "23","Padang Sambian Kaja II"

    data_wilayah memuat data wilayah sebagai berikut:
    "id","wilayah"
    "1","Denpasar Timur"
    "2","Denpasar Selatan"
    "3","Denpasar Barat"
    "4","Denpasar Utara"

    Tentukan tabel yang sesuai (`data_jemaat` atau `data_kl`) berdasarkan pertanyaan pengguna. 
    Jika pengguna meminta data sesuai struktur diatas, berikan SQL query untul MySQL 8.0 dengan hanya memberikan kolom yang relevan sesuai dengan data dan jangan jawab dalam bentuk percakapan.
    Selalu gunakan LIKE %% untuk Nama.
    PENTING: Jika menggunakan GROUP BY, pastikan semua kolom non-agregat dalam SELECT list juga ada dalam GROUP BY clause untuk menghindari error `sql_mode=only_full_group_by`.
    Jika tidak, jawab secara alami seperti obrolan.
    EOT;

        $wantsTable = str_contains(strtolower($userInput), 'tabel') || str_contains(strtolower($userInput), 'table');

        $prompt = $schemaDescription . "\n\nPertanyaan pengguna:\n" . $userInput;

        Log::info($prompt);

        try {
            $chat = Gemini::generativeModel(model: 'gemini-2.0-flash');
            $response = $chat->generateContent($prompt)->text();
            $data = ['success' => true];

            Log::info($response);

            if ($wantsTable && preg_match('/```sql(.*?)```/s', $response, $matches)) {
                $sql = trim($matches[1]);
                try {
                    $results = DB::select(DB::raw($sql));
                    if (empty($results)) {
                        $data['message'] = 'Tidak ada data ditemukan.';
                    } else {
                        $data['headers'] = array_keys(get_object_vars($results[0]));
                        $data['rows'] = array_map(function($row) {
                            return get_object_vars($row);
                        }, $results);
                    }
                } catch (\Exception $e) {
                    throw new \Exception('Error SQL: ' . $e->getMessage());
                }
            } else {
                preg_match('/```sql(.*?)```/s', $response, $matches);
                if($matches) {
                    $sql = trim($matches[1]);
                    $results = DB::select(DB::raw($sql));
                    if (empty($results)) {
                        $data['message'] = 'Tidak ada data ditemukan.';
                    } else {
                        $tableData = [];
                        $headers = array_keys(get_object_vars($results[0]));
                        $rows = array_map(function($row) {
                            return get_object_vars($row);
                        }, $results);
                        $stringed = "Data Master:\n";
                        $stringed .= <<<EOT
                        Tabel data_sektor memuat data sektor sebagai berikut:
                        "id","nama"
                        "1","Dangin Puri"
                        "2","Sumerta I"
                        "3","Sumerta II"
                        "4","Tonja"
                        "5","Penatih"
                        "6","Sanur"
                        "7","Panjer"
                        "8","Renon"
                        "9","Sesetan I & II"
                        "10","Sidakarya"
                        "11","Pedungan Kuta"
                        "12","Dauh Puri I"
                        "13","Pemecutan"
                        "14","Peguyangan"
                        "15","Ubung Kaja"
                        "16","Padang Sambian Kelod I"
                        "17","Padang Sambian Kaja I"
                        "18","Kesiman"
                        "19","Dauh Puri II"
                        "20","Tegal Harum"
                        "21","Tegal Kertha"
                        "22","Padang Sambian Kelod II"
                        "23","Padang Sambian Kaja II"

                        data_wilayah memuat data wilayah sebagai berikut:
                        "id","wilayah"
                        "1","Denpasar Timur"
                        "2","Denpasar Selatan"
                        "3","Denpasar Barat"
                        "4","Denpasar Utara"

                        Tabel 'data_statuskl' menyimpan informasi PERAN dengan data sebagai berikut:
                        "id","nama"
                        "1","Kepala Keluarga"
                        "2","Istri / Pasangan"
                        "3","Anak"
                        "4","Saudara"
                        "5","Orang Tua"
                        "6","Menantu"
                        "7","Cucu"
                        "8","Lainnya"
                        EOT;
                        $stringed .= "Query:\n";
                        $stringed .= $sql;
                        $stringed .= "\n";
                        $stringed .= "Data:\n";
                        $stringed .= implode("\t", $headers) . "\n";
                        foreach ($rows as $row) {
                            $stringed .= implode("\t", $row) . "\n";
                        }
                        $stringed .= "Tanggal hari ini adalah: " . $dateNow . "\n";
                        $stringed .= "Berdasarkan data diatas, berikan penjelasan relevan yang sesuai dengan permintaan user: " . $userInput . "\n";
                        $stringed .= "Jangan tambahkan kata atau kalimat seperti 'berdasarkan data yang anda berikan' karena data diambil otomatis di database";

                        Log::info($stringed);
                        
                        $explanation = $chat->generateContent($stringed)->text();
                        
                        $data['headers'] = $headers;
                        $data['rows'] = $rows;
                        $data['explanation'] = $explanation;
                        $data['date'] = $dateNow;
                    }
                } else {
                    $data['message'] = $response;
                }
            }
            
            return response()->json($data);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => $e->getMessage()
            ], 500);
        }
    }

}
