<?php

namespace App\Http\Controllers;

use App\Models\DataAnggotakl;
use App\Models\DataJemaat;
use App\Models\DataKl;
use App\Models\DataSektor;
use App\Models\DataStatus;
use App\Models\DataWilayah;
use Exception;
use Illuminate\Http\Request;
    
class KeluargaController extends Controller
{
    public function index(Request $request){

        if($request->search){
            $dataJemaat = DataKl::where("NAMA_KELUARGA","LIKE","%".$request->search."%")->orWhere("ID_KELUARGA","LIKE","%".$request->search."%")->paginate();
        } else {
            $dataJemaat = DataKl::paginate();
        }
        return response()->json(array('data' => $dataJemaat));
    }
    public function find(Request $request){
        // try{
            $dataJemaat = DataKl::find($request->id);
            $dataJemaat->STATUS = DataStatus::find($dataJemaat->STATUS);
            $dataJemaat->WILAYAH = DataWilayah::find($dataJemaat->WILAYAH);
            $dataJemaat->SEKTOR = DataSektor::find($dataJemaat->SEKTOR);
            return response()->json(array('data' => $dataJemaat));
        // } catch(Exception $ex){
        //     return response()->json(array('success' => false, 'message' => 'Gagal, error: ' . $ex->getMessage()), 400);
        // }
    }
    public function add(Request $request){
        try{
            DataKl::create($request->all());
            return response()->json(array('success' => true, 'message' => 'Data Tersimpan'));
        } catch(Exception $ex){
            return response()->json(array('success' => false, 'message' => 'Gagal, error: ' . $ex->getMessage()), 400);
        }
    }
    public function update(Request $request){
        try{
            $update = DataKl::find($request->ID_KELUARGA);
            $update->update($request->all());
            return response()->json(array('success' => true, 'message' => 'Data Tersimpan'));
        } catch(Exception $ex){
            return response()->json(array('success' => false, 'message' => 'Gagal, error: ' . $ex->getMessage()), 400);
        }
    }
    public function delete(Request $request){
        try{
            $update = DataKl::find($request->ID_KELUARGA);
            $update->delete();
            return response()->json(array('success' => true, 'message' => 'Data Terhapus'));
        } catch(Exception $ex){
            return response()->json(array('success' => false, 'message' => 'Gagal, error: ' . $ex->getMessage()), 400);
        }
    }
    public function getAnggota(Request $request){
        try{
            $anggota = DataJemaat::where('ID_KELUARGA', '=', $request->id)->orderBy('PERAN')->paginate();
            return response()->json(array('data' => $anggota));
        } catch(Exception $ex){
            return response()->json(array('success' => false, 'message' => 'Gagal, error: ' . $ex->getMessage()), 400);
        }
    }
    public function anggotaAdd(Request $request){
        try{
            $update = DataJemaat::find($request->id);
            $update->update($request->all());
            return response()->json(array('success' => true, 'message' => 'Data Tersimpan'));
        } catch(Exception $ex){
            return response()->json(array('success' => false, 'message' => 'Gagal, error: ' . $ex->getMessage()), 400);
        }
    }
    public function anggotaDestroy(Request $request){
        try{
            $update = DataJemaat::find($request->id);
            $update->update($request->all());
            return response()->json(array('success' => true, 'message' => 'Data Terhapus'));
        } catch(Exception $ex){
            return response()->json(array('success' => false, 'message' => 'Gagal, error: ' . $ex->getMessage()), 400);
        }
    }
}
