<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use DateTimeInterface;

/**
 * Class DataJemaat
 *
 * @property int $id
 * @property int|null $ID_JEMAAT
 * @property string|null $ID_SINODE
 * @property int|null $ID_KELUARGA
 * @property int $WILAYAH
 * @property int|null $SEKTOR
 * @property string|null $NAMA
 * @property string|null $JK
 * @property string|null $TEMPAT_KELAHIRAN
 * @property Carbon|null $TGL_LAHIR
 * @property int|null $umur
 * @property string|null $PERAN
 * @property string|null $PERANETC
 * @property string|null $ALAMAT
 * @property string|null $KOTA
 * @property string|null $PROPINSI
 * @property string|null $KODEPOS
 * @property string|null $NEGARA
 * @property string|null $HP
 * @property string|null $EMAIL
 * @property string|null $STATUS
 * @property string|null $KEWARGANEGARAAN
 * @property string|null $GOL_DARAH
 * @property string|null $STATUS_PERKAWINAN
 * @property string|null $AYAH
 * @property string|null $IBU
 * @property Carbon|null $TGL_BAPTIS
 * @property string|null $TEMPAT_BAPTIS
 * @property string|null $DIBAPTIS_OLEH
 * @property Carbon|null $TGL_SIDI
 * @property string|null $TEMPAT_SIDI
 * @property string|null $DISIDI_OLEH
 * @property string|null $PINDAHAN
 * @property string|null $PENDIDIKAN
 * @property string|null $JURUSAN
 * @property string|null $PEKERJAAN
 * @property string|null $PEKERJAANETC
 * @property string|null $TEMPAT_KERJA
 * @property string|null $ALAMAT_KERJA
 * @property string|null $BIDANG_USAHA
 * @property string|null $JABATAN
 * @property string|null $JABATANETC
 * @property string|null $PROFESI
 * @property string|null $PROFESIETC
 * @property string|null $HOBBY
 * @property string|null $HOBBYETC
 * @property string|null $MINAT
 * @property string|null $MINATETC
 * @property string|null $MINAT_PELAYANAN
 * @property Carbon $updated_at
 * @property Carbon|null $TANGGAL_MENINGGAL
 * @property Carbon|null $TANGGAL_PINDAH
 * @property string|null $TEMPAT_SEMAYAM
 *
 * @package App\Models
 */
class DataJemaat extends Model
{
	protected $table = 'data_jemaat';
	public $timestamps = false;

	protected $casts = [
		'ID_JEMAAT' => 'int',
		'ID_KELUARGA' => 'int',
	];

	protected $dates = [
		'TGL_LAHIR',
		'TGL_BAPTIS',
		'TGL_SIDI',
		'TANGGAL_MENINGGAL',
		'TANGGAL_PINDAH',
        'TGL_AGAMA_LAIN',
        'TGL_DARI_KRISTEN'
	];

	protected $fillable = [
		'ID_JEMAAT',
		'ID_SINODE',
		'ID_KELUARGA',
		'WILAYAH',
		'SEKTOR',
		'NAMA',
		'JK',
		'TEMPAT_KELAHIRAN',
		'TGL_LAHIR',
		'umur',
		'PERAN',
		'PERANETC',
		'ALAMAT',
		'KOTA',
		'PROPINSI',
		'KODEPOS',
		'NEGARA',
		'HP',
		'EMAIL',
		'STATUS',
		'KEWARGANEGARAAN',
		'GOL_DARAH',
		'STATUS_PERKAWINAN',
		'AYAH',
		'IBU',
		'TGL_BAPTIS',
		'TEMPAT_BAPTIS',
		'DIBAPTIS_OLEH',
		'TGL_SIDI',
		'TEMPAT_SIDI',
		'DISIDI_OLEH',
		'PINDAHAN',
		'PENDIDIKAN',
		'JURUSAN',
		'PEKERJAAN',
		'PEKERJAANETC',
		'TEMPAT_KERJA',
		'ALAMAT_KERJA',
		'BIDANG_USAHA',
		'JABATAN',
		'JABATANETC',
		'PROFESI',
		'PROFESIETC',
		'HOBBY',
		'HOBBYETC',
		'MINAT',
		'MINATETC',
		'MINAT_PELAYANAN',
		'TANGGAL_MENINGGAL',
		'TANGGAL_PINDAH',
        'TGL_AGAMA_LAIN',
        'TGL_DARI_KRISTEN',
        'DISABILITAS',
        'PINDAHAN_AGAMA_LAIN',
        'PINDAHAN_DARI_KRISTEN',
		'TEMPAT_SEMAYAM'
	];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d');
    }

    protected $appends = ['field_peran'];

    public function getFieldPeranAttribute()
    {
        return DataStatuskl::find($this->PERAN);
    }

	public function wilayah() { return $this->belongsTo(DataWilayah::class, 'WILAYAH'); }
	public function sektor() { return $this->belongsTo(DataSektor::class, 'SEKTOR'); }
	public function statusKeluarga() { return $this->belongsTo(DataStatusKL::class, 'PERAN'); }
	public function keluarga() { return $this->belongsTo(DataKL::class, 'ID_KELUARGA'); }

}
