<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class DataKl
 *
 * @property int $ID_KELUARGA
 * @property string|null $SEKTOR
 * @property string|null $WILAYAH
 * @property string|null $STATUS_KELUARGA
 * @property string|null $NAMA_KELUARGA
 * @property string|null $STATUS
 * @property string|null $ALAMAT
 * @property string|null $KOTA
 * @property string|null $PROPINSI
 * @property string|null $KODEPOS
 * @property string|null $NEGARA
 * @property string|null $TELP
 * @property string|null $KET_KHUSUS
 * @property string|null $TGL_NIKAH
 * @property string|null $TGL_CAPIL
 * @property string|null $TEMPAT_CAPIL
 * @property string|null $TEMPAT_NIKAH
 * @property Carbon|null $updated_at
 *
 * @package App\Models
 */
class DataKl extends Model
{
	protected $table = 'data_kl';
	protected $primaryKey = 'ID_KELUARGA';
	public $incrementing = false;
	public $timestamps = false;
	protected $appends = ['nomor_kk'];

	protected $casts = [
		'ID_KELUARGA' => 'int'
	];

	protected $fillable = [
        'ID_KELUARGA',
		'SEKTOR',
		'WILAYAH',
		'STATUS_KELUARGA',
		'NAMA_KELUARGA',
		'STATUS',
		'ALAMAT',
		'KOTA',
		'PROPINSI',
		'KODEPOS',
		'NEGARA',
		'TELP',
		'KET_KHUSUS',
		'TGL_NIKAH',
		'TGL_CAPIL',
		'TEMPAT_CAPIL',
		'TEMPAT_NIKAH'
	];

	public function getNomorKkAttribute(){
		$Sek_id = "XX";
		$Wil_id = "XX";
		
		if ($this->attributes['SEKTOR']) {
			$Sektor = DataSektor::where('id', $this->attributes['SEKTOR'])->first();
			if ($Sektor) {
				$Sek_id = str_pad($Sektor->id, 2, "0", STR_PAD_LEFT);
			}
		}
		
		if ($this->attributes['WILAYAH']) {
			$Wilayah = DataWilayah::where('id', $this->attributes['WILAYAH'])->first();
			if ($Wilayah) {
				$Wil_id = str_pad($Wilayah->id, 2, "0", STR_PAD_LEFT);
			}
		}
	
		$id_kk = str_pad($this->attributes['ID_KELUARGA'], 4, "0", STR_PAD_LEFT);
		
		return $Wil_id . '-' . $Sek_id . '-' . $id_kk;
	}
}
