<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('login', 'LoginController@login');
Route::group(['middleware' => 'auth:api'], function(){
    Route::get('/dashboard', 'DashboardController@index');
    Route::prefix('/jemaat')->group(function() {
        Route::get('/', 'JemaatController@index');
        Route::get('/anggota', 'JemaatController@getAnggota');
        Route::get('/{id}', 'JemaatController@find');
        Route::post('/add', 'JemaatController@add');
        Route::put('/update', 'JemaatController@update');
    });
    Route::prefix('/keluarga')->group(function() {
        Route::get('/', 'KeluargaController@index');
        Route::get('/{id}', 'KeluargaController@find');
        Route::post('/add', 'KeluargaController@add');
        Route::put('/update', 'KeluargaController@update');
        Route::delete('/delete', 'KeluargaController@destroy');
        Route::prefix('/anggota')->group(function() {
            Route::get('/{id}', 'KeluargaController@getAnggota');
            Route::post('/add', 'KeluargaController@anggotaAdd');
            Route::post('/remove', 'KeluargaController@anggotaDestroy');
        });
    });
    Route::prefix('/sync')->group(function() {
        Route::post('/id', 'SynchronizationController@id');
        Route::post('/data', 'SynchronizationController@data');
    });
    Route::get('/data', 'DataController@data');
    Route::get('/user','LoginController@getUser');
    
});
Route::post('/chat', 'JemaatController@handleChat');
