<?php

declare(strict_types=1);

namespace Gemini\Data;

use Gemini\Contracts\Arrayable;
use Gemini\Enums\Language;

/**
 * Code generated by the model that is meant to be executed, and the result returned to the model.
 * Only generated when using the CodeExecution tool, in which the code will be automatically executed, and a corresponding CodeExecutionResult will also be generated.
 *
 * https://ai.google.dev/api/caching#ExecutableCode
 */
final class ExecutableCode implements Arrayable
{
    /**
     * @param  Language  $language  Required. Programming language of the code.
     * @param  string  $code  Required. The code to be executed.
     */
    public function __construct(
        public readonly Language $language,
        public readonly string $code,
    ) {}

    /**
     * @param  array{ language: string, code: string }  $attributes
     */
    public static function from(array $attributes): self
    {
        return new self(
            language: Language::from($attributes['language']),
            code: $attributes['code'],
        );
    }

    public function toArray(): array
    {
        return [
            'language' => $this->language->value,
            'code' => $this->code,
        ];
    }
}
